#include <bits/stdc++.h>

struct Ivica {
	size_t a;
	size_t b;
};

template <typename T>
auto unesi() -> T {
	T t;
	std::cin >> t;
	return t;
}

auto zameni_mesta(std::vector<size_t>& p) -> void {
	const auto a = unesi<size_t>() - 1;
	const auto b = unesi<size_t>() - 1;

	const auto tmp = p[a];
	p[a] = p[b];
	p[b] = tmp;
}

auto nadji_ivice(const std::vector<Ivica>& ivice) -> std::vector<std::vector<size_t>> {
	static std::vector<std::vector<size_t>> rezultat;

	if (rezultat.size() == ivice.size() + 1) {
		return rezultat;
	}

	for (size_t i = 0; i < ivice.size() + 1; ++i) {
		rezultat.push_back(std::vector<size_t>{});
	}

	for (const auto& ivica : ivice) {
		rezultat[ivica.a].push_back(ivica.b);
		rezultat[ivica.b].push_back(ivica.a);
	}

	return rezultat;
}

auto bfs(const std::vector<size_t>& p, const std::vector<Ivica>& ivice, const size_t l, const size_t r, const size_t x) -> std::vector<size_t> {
	const static std::vector<std::vector<size_t>> veze = nadji_ivice(ivice);
	std::vector<size_t> duzine_puteva;
	std::vector<bool> poseceni;

	for (size_t i = 0; i < ivice.size() + 1; ++i) {
		duzine_puteva.push_back(0);
		poseceni.push_back(false);
	}

	std::list<size_t> naredni_gradovi{ x };
	poseceni[x] = true;

	while (!naredni_gradovi.empty()) {
		const auto trenutni = naredni_gradovi.front();
		const auto duzina = duzine_puteva[trenutni];
		naredni_gradovi.pop_front();

		for (const auto& buduci : veze[trenutni]) {
			if (poseceni[buduci]) {
				continue;
			}

			poseceni[buduci] = true;
			duzine_puteva[buduci] = duzina + 1;
			naredni_gradovi.push_back(buduci);
		}
	}

	return duzine_puteva;
}

auto nadji_najdalji(const std::vector<size_t>& p, const std::vector<Ivica>& ivice) -> size_t {
	const auto l = unesi<size_t>() - 1;
	const auto r = unesi<size_t>() - 1;
	const auto x = unesi<size_t>() - 1;

	const auto duzine_puteva = bfs(p, ivice, l, r, x);

	size_t max = 0;
	for (size_t i = l; i <= r; ++i) {
		max = std::max(max, duzine_puteva[p[i]]);
	}

	return max;
}

auto main() -> int {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
	const auto n = unesi<size_t>();

	std::vector<size_t> p;
	for (size_t i = 0; i < n; ++i) {
		p.push_back(unesi<size_t>() - 1);
	}

	std::vector<Ivica> ivice;
	for (size_t i = 0; i < n - 1; ++i) {
		ivice.push_back(Ivica{ unesi<size_t>() - 1, unesi<size_t>() - 1 });
	}

	const auto q = unesi<size_t>();

	for (size_t i = 0; i < q; ++i) {
		const auto command = unesi<int>();

		if (command == 1) {
			zameni_mesta(p);
		} else {
			std::cout << nadji_najdalji(p, ivice) << '\n';
		}
	}
}